--[[ Instruction:
	* XMin, YMin, XMax and YMax - if Claw is inside this area then create a silent teleport...
	* TweakX and TweakY - ...at this position...
	* SpeedX and SpeedY - ...with this destination.
	* Directions 4 and 6 are a vertical teleport lines - Height should be defined in pixels.
	* Directions 2 and 8 are a horizontal teleport lines - Width should be defined in pixels.
	Also:
	* 'Always Active' flag should be set for all objects that'll appear on the screen at the teleport's destination.
	* Teleport's destination shouldn't be close to its location.
]]

function main(self)
	if self.State == 0 then
		self.State = 1
		self.DrawFlags.NoDraw = true
	end
	if self.State == 1 and GetClaw():InMinMax(self) then
		CreateObject{
			X = self.XTweak,
			Y = self.YTweak,
			name = "SilentTeleportLine",
			Direction = self.Direction,
			SpeedX = self.SpeedX,
			SpeedY = self.SpeedY,
			Width = self.Width,
			Height = self.Height,
			Smarts = self.Smarts
		}
		self:Destroy()
	end
end